/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.licenser.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIpLocator {
    private static final String GEOIP_SERVICE = "http://freegeoip.net/json/";
    private static final Logger LOG = LoggerFactory.getLogger(GeoIpLocator.class);
    private static final int RETURN_OK = 200;
    private static final String PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final String CLASS_A_PREFIX = "10.";
    private static final String[] CLASS_B_PREFIX = new String[]{"172.16.", "172.17.", "172.18.", "172.19.", "172.20.", "172.21.", "172.22.", "172.23.", "172.24.", "172.25.", "172.26.", "172.27.", "172.28.", "172.29.", "172.30.", "172.31."};
    private static final String CLASS_C_PREFIX = "192.168.";

    public final String sendRequest(String string) {
        String string2 = GEOIP_SERVICE.concat(string);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "Error";
        BufferedReader bufferedReader = null;
        try {
            LOG.info("\nSending 'GET' request to URL : " + string2);
            URL uRL = new URL(string2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    stringBuilder.append(string4);
                    string4 = bufferedReader.readLine();
                }
                bufferedReader.close();
                string3 = stringBuilder.toString();
            } else {
                string3 = "Error ".concat(Integer.toString(n));
            }
            LOG.info(string3);
        }
        catch (MalformedURLException malformedURLException) {
            LOG.error(malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            LOG.error(iOException.getMessage());
            IOUtils.closeQuietly(bufferedReader);
        }
        return string3;
    }

    public final GeoIpData getIpData(String string) {
        String string2 = this.validateFormat(string) && this.validateIp(string) ? this.sendRequest(string) : "Error";
        GeoIpData geoIpData = new GeoIpData();
        try {
            if (!string2.startsWith("Error")) {
                JSONObject jSONObject = new JSONObject(string2);
                geoIpData.setIpAddress(jSONObject.getString("ip"));
                geoIpData.setCountryCode(jSONObject.getString("country_code"));
                geoIpData.setCountryName(jSONObject.getString("country_name"));
                geoIpData.setRegionCode(jSONObject.getString("region_code"));
                geoIpData.setRegionName(jSONObject.getString("region_name"));
                geoIpData.setCity(jSONObject.getString("city"));
                geoIpData.setZip(jSONObject.getString("zipcode"));
                geoIpData.setLatitude(jSONObject.getDouble("latitude"));
                geoIpData.setLongitude(jSONObject.getDouble("longitude"));
                geoIpData.setMetroCode(jSONObject.getString("metro_code"));
                geoIpData.setAreaCode(jSONObject.getString("area_code"));
            }
        }
        catch (JSONException jSONException) {
            LOG.error(jSONException.getMessage());
        }
        return geoIpData;
    }

    private boolean validateIp(String string) {
        boolean bl = true;
        if (string.startsWith(CLASS_A_PREFIX) || string.startsWith(CLASS_C_PREFIX)) {
            bl = false;
        }
        for (int i = 0; i < CLASS_B_PREFIX.length && bl; ++i) {
            if (!string.startsWith(CLASS_B_PREFIX[i])) continue;
            bl = false;
        }
        return bl;
    }

    private boolean validateFormat(String string) {
        Pattern pattern = Pattern.compile(PATTERN);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static class GeoIpData {
        private String ipAddress;
        private String countryCode;
        private String countryName;
        private String regionCode;
        private String regionName;
        private String city;
        private String zip;
        private Double latitude;
        private Double longitude;
        private String metroCode;
        private String areaCode;

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String string) {
            this.ipAddress = string;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        public final void setCountryCode(String string) {
            this.countryCode = string;
        }

        public final String getCountryName() {
            return this.countryName;
        }

        public final void setCountryName(String string) {
            this.countryName = string;
        }

        public final String getRegionCode() {
            return this.regionCode;
        }

        public final void setRegionCode(String string) {
            this.regionCode = string;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String string) {
            this.regionName = string;
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String string) {
            this.city = string;
        }

        public final String getZip() {
            return this.zip;
        }

        public final void setZip(String string) {
            this.zip = string;
        }

        public final Double getLatitude() {
            return this.latitude;
        }

        public final void setLatitude(Double d) {
            this.latitude = d;
        }

        public final Double getLongitude() {
            return this.longitude;
        }

        public final void setLongitude(Double d) {
            this.longitude = d;
        }

        public final String getAreaCode() {
            return this.areaCode;
        }

        public final void setAreaCode(String string) {
            this.areaCode = string;
        }

        public final String getMetroCode() {
            return this.metroCode;
        }

        public final void setMetroCode(String string) {
            this.metroCode = string;
        }
    }
}

