/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;

public class SonarQubeServerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeServerManager.class);
    private final WsClient wsClient;

    public SonarQubeServerManager(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public SonarQubeServerManager(String string, String string2) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected static String getSonarQubeVersion(WsClient wsClient) throws SonarQubeException {
        return new SonarQubeServerManager(wsClient).getSonarQubeVersion();
    }

    protected static boolean isAuthenticationRequired(WsClient wsClient) throws SonarQubeException {
        return new SonarQubeServerManager(wsClient).isAuthenticationRequired();
    }

    public String getSonarQubeVersion() throws SonarQubeException {
        try {
            String string = this.wsClient.server().version();
            LOGGER.debug("SonarQube version: {}", (Object)string);
            return string;
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format("Error getting SonarQube version, error -> %s", httpException.content()));
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.debug(String.format("Error getting SonarQube version, error -> %s", exception));
            throw new SonarQubeException(String.format("Error getting SonarQube version -> %s", exception.getMessage()));
        }
    }

    public boolean isAuthenticationRequired() throws SonarQubeException {
        try {
            boolean bl = this.wsClient.authentication().validate().contains("false");
            LOGGER.debug("SonarQube authentication required: {}", (Object)bl);
            return bl;
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format("Error checking SonarQube authentication, error -> %s", httpException.content()));
            throw ExceptionUtils.getSonarQubeException(httpException.content());
        }
        catch (Exception exception) {
            LOGGER.debug(String.format("Error checking SonarQube authentication, error -> %s", exception));
            throw new SonarQubeException(String.format("Error checking SonarQube authentication -> %s", exception.getMessage()));
        }
    }
}

