/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.licenser;

import com.bitegarden.licenser.checker.LicenseChecker;
import com.bitegarden.licenser.common.data.DownloadInfo;
import com.bitegarden.licenser.common.data.LicenseStatus;
import com.bitegarden.sonar.licenser.LicenseWS;
import com.bitegarden.sonar.licenser.LicensedPluginShared;
import com.bitegarden.sonar.plugins.common.DisableablePlugin;
import com.bitegarden.sonar.plugins.common.ctx.PluginContext;
import com.bitegarden.sonar.plugins.common.exception.PluginFatalException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public abstract class LicensedPlugin
extends DisableablePlugin {
    public static final String CTXKEY_LICENSE_CERT_PROP_KEY = "LicensedPlugin.licenseCertPropKey";
    public static final String AJAX_INJECT_LICENSE_INFO = "new function(pluginKey, domElId) { \nvar msgEl = document.getElementById(domElId); \nnew Ajax.Request('api/plugins/'+pluginKey+'License/getHtmlLicenseInfo', { \nonSuccess: function(response) { \nmsgEl.innerHTML =  response.responseJSON.evalJSON().getHtmlLicenseInfo; \n} \n}); \n}";
    private static final List<LicenseStatus> VALID_STATUS = Arrays.asList(LicenseStatus.EVALUATION, LicenseStatus.LICENSED, LicenseStatus.SUPPORTED);

    public LicensedPlugin(String string, String string2) {
        super(string);
        String string3 = string2;
        if (StringUtils.isBlank(string3)) {
            throw new PluginFatalException("You have to define the license cert property key when using a LicensedPlugin");
        }
        LicensedPlugin.setLicenseCertPropKey(string3);
    }

    public static final String getLicenseCertPropKey() {
        String string = (String)PluginContext.get().getProperty(CTXKEY_LICENSE_CERT_PROP_KEY);
        if (StringUtils.isBlank(string)) {
            throw new PluginFatalException("Make sure you are using a LicensedPlugin and passing a license cert property key to the constructor. If you are testing, try to simulate Sonar behaviour calling \nPluginContext.get().setProperty(LicensedPlugin.CTXKEY_LICENSE_CERT_PROP_KEY, \"yourpluginkey.license_cert\")");
        }
        return string;
    }

    private static void setLicenseCertPropKey(String string) {
        PluginContext.get().setProperty(CTXKEY_LICENSE_CERT_PROP_KEY, string);
    }

    protected static String getLicenseCertFromConfig(Settings settings) {
        String string = LicensedPlugin.getLicenseCertPropKey();
        String string2 = null;
        if (StringUtils.isNotBlank(string)) {
            string2 = settings.getString(string);
        }
        return string2;
    }

    protected static boolean isValidStatus(LicenseStatus licenseStatus) {
        return VALID_STATUS.contains((Object)licenseStatus);
    }

    protected static boolean checkIfLicenseOkAndWriteMsgIfNot(Settings settings, Class<?> clazz) {
        return LicensedPlugin.isValidStatus(LicensedPlugin.getLicenseStatusAndWriteMsgIfNotValid(settings, clazz));
    }

    public static LicenseStatus getLicenseStatusAndWriteMsgIfNotValid(String string, String string2) {
        return LicensedPlugin.getLicenseStatusAndWriteMsgIfNotValid(string, string2, LicensedPlugin.class);
    }

    protected static LicenseStatus getLicenseStatusAndWriteMsgIfNotValid(Settings settings, Class<?> clazz) {
        String string = settings.getString("sonar.server_id");
        return LicensedPlugin.getLicenseStatusAndWriteMsgIfNotValid(LicensedPlugin.getLicenseCertFromConfig(settings), string, clazz);
    }

    protected static LicenseStatus getLicenseStatusAndWriteMsgIfNotValid(String string, String string2, Class<?> clazz) {
        LicenseStatus licenseStatus = LicenseChecker.getLicenseStatus(string);
        DownloadInfo downloadInfo = LicenseChecker.getDownloadInfo();
        String string3 = downloadInfo.getProductVersion();
        string3 = StringUtils.isBlank(string3) ? "" : " " + string3;
        String string4 = downloadInfo.getProductName() + string3;
        Logger logger = Loggers.get(clazz);
        if (LicensedPlugin.isValidStatus(licenseStatus)) {
            if (!licenseStatus.equals((Object)LicenseStatus.EVALUATION) && !LicensedPlugin.isServerIdOK(downloadInfo, string, string2)) {
                licenseStatus = LicenseStatus.INVALID_LICENSE;
                logger.debug("Plugin '{}': Invalid Server ID '{}'", new Object[]{string4, string2});
            }
        } else {
            logger.debug("Plugin '{}': Invalid license status '{}'", new Object[]{string4, licenseStatus});
        }
        return licenseStatus;
    }

    private static boolean isServerIdOK(DownloadInfo downloadInfo, String string, String string2) {
        boolean bl = true;
        if (downloadInfo.getIsServerIdRequired() != null && downloadInfo.getIsServerIdRequired().booleanValue() && (string2 == null || LicenseChecker.getServerId(string) == null || !LicenseChecker.getServerId(string).equals(string2))) {
            bl = false;
        }
        return bl;
    }

    public static String getHtmlEvalWaterMark(String string, String string2) {
        String string3 = StringUtils.isBlank(string2) ? "Evaluation License - {0} days remaining" : string2;
        long l = LicenseChecker.getUseRemainingDays(string);
        String string4 = MessageFormat.format(string3, l);
        String string5 = LicenseChecker.getDownloadKey();
        return LicensedPluginShared.getHtmlEvalWaterMark(string4, string5);
    }

    public static String getHtmlEvalWaterMark(String string) {
        return LicensedPlugin.getHtmlEvalWaterMark(string, null);
    }

    protected static String getHtmlEvalWaterMark(Settings settings, String string) {
        return LicensedPlugin.getHtmlEvalWaterMark(LicensedPlugin.getLicenseCertFromConfig(settings), string);
    }

    protected static String getHtmlEvalWaterMark(Settings settings) {
        return LicensedPlugin.getHtmlEvalWaterMark(settings, null);
    }

    @Override
    public final List getDisableablePluginExtensions() {
        ArrayList<Class<LicenseWS>> arrayList = new ArrayList<Class<LicenseWS>>();
        arrayList.addAll(this.getLicensedPluginExtensions());
        arrayList.add(LicenseWS.class);
        return arrayList;
    }

    public abstract List getLicensedPluginExtensions();
}

