/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import es.sonarqube.api.SonarQubeCustomRequestParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.WsResponse;

public class SonarQubeCustomRequestManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeCustomRequestManager.class);
    private final WsClient wsClient;

    public SonarQubeCustomRequestManager(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public SonarQubeCustomRequestManager(String string, String string2) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected static String callCustomGetMethod(WsClient wsClient, String string, String string2, List<SonarQubeCustomRequestParam> list) {
        return new SonarQubeCustomRequestManager(wsClient).callCustomGetMethodWithStringResponse(string, string2, list);
    }

    protected static JsonObject callCustomGetMethodWithJsonObjectResponse(WsClient wsClient, String string, String string2, List<SonarQubeCustomRequestParam> list) {
        return new SonarQubeCustomRequestManager(wsClient).callCustomGetMethodWithJsonObjectResponse(string, string2, list);
    }

    protected static <T> T callCustomGetMethodWithSpecificResponseType(WsClient wsClient, String string, String string2, List<SonarQubeCustomRequestParam> list, Class<T> clazz) {
        return new SonarQubeCustomRequestManager(wsClient).callCustomGetMethodWithSpecificResponseType(string, string2, list, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String callCustomGetMethodWithStringResponse(String string, String string2, List<SonarQubeCustomRequestParam> list) {
        try {
            LOGGER.debug("Calling custom get method for api service ({}) and method ({})", (Object)string, (Object)string2);
            StringBuilder stringBuilder = new StringBuilder(this.wsClient.wsConnector().baseUrl());
            StringBuilder stringBuilder2 = new StringBuilder(string);
            StringBuilder stringBuilder3 = new StringBuilder(string2);
            StringBuilder stringBuilder4 = new StringBuilder();
            if (stringBuilder.toString().endsWith("/")) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            if (stringBuilder2.toString().startsWith("/")) {
                stringBuilder2.setLength(stringBuilder2.length() - 1);
            }
            if (stringBuilder3.toString().startsWith("/")) {
                stringBuilder3.setLength(stringBuilder3.length() - 1);
            }
            stringBuilder4.append((CharSequence)stringBuilder).append("/api/").append((CharSequence)stringBuilder2).append("/").append((CharSequence)stringBuilder3);
            GetRequest getRequest = new GetRequest(stringBuilder4.toString());
            list.forEach(sonarQubeCustomRequestParam -> getRequest.setParam(sonarQubeCustomRequestParam.getParamKey(), sonarQubeCustomRequestParam.getParamValue()));
            try (WsResponse wsResponse = this.wsClient.wsConnector().call(getRequest).failIfNotSuccessful();){
                String string3 = wsResponse.content();
                if (string3 != null) {
                    LOGGER.debug("Calling custom get method successfully, returning result...");
                    String string4 = string3;
                    return string4;
                }
                LOGGER.warn("Calling custom get method return null response... we return empty response...");
                return "{}";
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error calling custom get method for api service ({}) and method ({}). Reason -> {}", string, string2, exception.getMessage());
            LOGGER.debug("Error calling custom get method for api service ({}) and method ({})", string, string2, exception);
        }
        return "{}";
    }

    public JsonObject callCustomGetMethodWithJsonObjectResponse(String string, String string2, List<SonarQubeCustomRequestParam> list) {
        return new Gson().fromJson(this.callCustomGetMethodWithStringResponse(string, string2, list), JsonObject.class);
    }

    public <T> T callCustomGetMethodWithSpecificResponseType(String string, String string2, List<SonarQubeCustomRequestParam> list, Class<T> clazz) {
        return new Gson().fromJson(this.callCustomGetMethodWithStringResponse(string, string2, list), clazz);
    }
}

