/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import es.sonarqube.api.SearchQualityProfileResponse;
import es.sonarqube.api.SonarQubeCustomRequestParam;
import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeCustomRequestManager;
import es.sonarqube.managers.SonarQubeURLManager;
import es.sonarqube.utils.ParamsUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Qualityprofiles;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.qualityprofiles.SearchRequest;

public class SonarQubeQualityProfileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeQualityProfileManager.class);
    private final WsClient wsClient;

    public SonarQubeQualityProfileManager(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public SonarQubeQualityProfileManager(String string, String string2) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected static String getQualityProfileKey(WsClient wsClient, String string, String string2, String string3) throws SonarQubeException {
        return new SonarQubeQualityProfileManager(wsClient).getQualityProfileKey(string, string2, string3);
    }

    protected static String getQualityProfileKey(WsClient wsClient, String string, String string2) throws SonarQubeException {
        return new SonarQubeQualityProfileManager(wsClient).getQualityProfileKey(string, string2, "");
    }

    public String getQualityProfileKey(String string, String string2) throws SonarQubeException {
        return this.getQualityProfileKey(string, string2, "");
    }

    public String getQualityProfileKey(String string, String string2, String string3) throws SonarQubeException {
        try {
            String string4 = "";
            if (ParamsUtils.hasValue(string)) {
                Qualityprofiles.SearchWsResponse searchWsResponse;
                LOGGER.debug("Contacting SonarQube to get qualityProfileKey from Quality profile name: {}", (Object)string);
                if (SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl())) {
                    return this.processSonarCloudQualityProfile(string, string2, string3);
                }
                SearchRequest searchRequest = new SearchRequest();
                searchRequest.setQualityProfile(string);
                if (ParamsUtils.hasValue(string2)) {
                    searchRequest.setLanguage(string2);
                }
                if ((searchWsResponse = this.wsClient.qualityprofiles().search(searchRequest)) != null && searchWsResponse.getProfilesList().size() == 1) {
                    LOGGER.debug("Getting quality profile key");
                    string4 = searchWsResponse.getProfiles(0).getKey();
                    return string4;
                }
                if (searchWsResponse != null && searchWsResponse.getProfilesList().size() > 1) {
                    LOGGER.debug("Error getting qualityProfileKey, obtained multiples Quality profiles, please configure language param ");
                    return string4;
                }
            }
            return string4;
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format("Error getting qualityProfileKey from Quality profile name (%s) ", string));
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.debug(String.format("Error getting qualityProfileKey from Quality profile name (%s) ", string));
            throw new SonarQubeException(String.format("Error getting qualityProfileKey, error -> %s", exception.getMessage()));
        }
    }

    private String processSonarCloudQualityProfile(String string, String string2, String string3) {
        Object object;
        String string4 = "";
        ArrayList<SonarQubeCustomRequestParam> arrayList = new ArrayList<SonarQubeCustomRequestParam>();
        SonarQubeCustomRequestParam sonarQubeCustomRequestParam = new SonarQubeCustomRequestParam();
        sonarQubeCustomRequestParam.setParamKey("qualityProfile");
        sonarQubeCustomRequestParam.setParamValue(string);
        arrayList.add(sonarQubeCustomRequestParam);
        arrayList.add(ParamsUtils.getOrganizationParam(string3));
        if (ParamsUtils.hasValue(string2)) {
            object = new SonarQubeCustomRequestParam();
            ((SonarQubeCustomRequestParam)object).setParamKey("language");
            ((SonarQubeCustomRequestParam)object).setParamValue(string2);
            arrayList.add((SonarQubeCustomRequestParam)object);
        }
        if ((object = SonarQubeCustomRequestManager.callCustomGetMethodWithSpecificResponseType(this.wsClient, "qualityprofiles", "search", arrayList, SearchQualityProfileResponse.class)) != null && ((SearchQualityProfileResponse)object).getProfiles().size() == 1) {
            LOGGER.debug("Getting quality profile key");
            string4 = ((SearchQualityProfileResponse)object).getProfiles().get(0).getKey();
            return string4;
        }
        if (object != null && ((SearchQualityProfileResponse)object).getProfiles().size() > 1) {
            LOGGER.debug("Error getting qualityProfileKey, obtained multiples Quality profiles, please configure language param ");
            return string4;
        }
        return string4;
    }
}

