/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Map;

public final class UtfHelpper {
    private static final boolean OLD_UTF8 = AccessController.doPrivileged(() -> Boolean.getBoolean("org.apache.xml.security.c14n.oldUtf8"));

    private UtfHelpper() {
    }

    public static void writeByte(String str, OutputStream out, Map<String, byte[]> cache) throws IOException {
        byte[] result = cache.get(str);
        if (result == null) {
            result = UtfHelpper.getStringInUtf8(str);
            cache.put(str, result);
        }
        out.write(result);
    }

    public static void writeCodePointToUtf8(int c2, OutputStream out) throws IOException {
        if (!Character.isValidCodePoint(c2) || c2 >= 55296 && c2 <= 56319 || c2 >= 56320 && c2 <= 57343) {
            out.write(63);
            return;
        }
        if (OLD_UTF8 && c2 >= 65536) {
            out.write(63);
            out.write(63);
            return;
        }
        if (c2 < 128) {
            out.write(c2);
            return;
        }
        int extraByte = 0;
        if (c2 < 2048) {
            extraByte = 1;
        } else if (c2 < 65536) {
            extraByte = 2;
        } else if (c2 < 0x200000) {
            extraByte = 3;
        } else if (c2 < 0x4000000) {
            extraByte = 4;
        } else if (c2 <= Integer.MAX_VALUE) {
            extraByte = 5;
        } else {
            out.write(63);
            return;
        }
        int shift = 6 * extraByte;
        byte write = (byte)(254 << 6 - extraByte | c2 >>> shift);
        out.write(write);
        for (int i = extraByte - 1; i >= 0; --i) {
            write = (byte)(0x80 | c2 >>> (shift -= 6) & 0x3F);
            out.write(write);
        }
    }

    public static void writeStringToUtf8(String str, OutputStream out) throws IOException {
        int length = str.length();
        int i = 0;
        while (i < length) {
            int c2 = str.codePointAt(i);
            i += Character.charCount(c2);
            if (!Character.isValidCodePoint(c2) || c2 >= 55296 && c2 <= 56319 || c2 >= 56320 && c2 <= 57343) {
                out.write(63);
                continue;
            }
            if (OLD_UTF8 && c2 >= 65536) {
                out.write(63);
                out.write(63);
                continue;
            }
            if (c2 < 128) {
                out.write(c2);
                continue;
            }
            int extraByte = 0;
            if (c2 < 2048) {
                extraByte = 1;
            } else if (c2 < 65536) {
                extraByte = 2;
            } else if (c2 < 0x200000) {
                extraByte = 3;
            } else if (c2 < 0x4000000) {
                extraByte = 4;
            } else if (c2 <= Integer.MAX_VALUE) {
                extraByte = 5;
            } else {
                out.write(63);
                continue;
            }
            int shift = 6 * extraByte;
            byte write = (byte)(254 << 6 - extraByte | c2 >>> shift);
            out.write(write);
            for (int j = extraByte - 1; j >= 0; --j) {
                write = (byte)(0x80 | c2 >>> (shift -= 6) & 0x3F);
                out.write(write);
            }
        }
    }

    public static byte[] getStringInUtf8(String str) {
        int length = str.length();
        boolean expanded = false;
        byte[] result = new byte[length];
        int i = 0;
        int out = 0;
        while (i < length) {
            int c2 = str.codePointAt(i);
            i += Character.charCount(c2);
            if (!Character.isValidCodePoint(c2) || c2 >= 55296 && c2 <= 56319 || c2 >= 56320 && c2 <= 57343) {
                result[out++] = 63;
                continue;
            }
            if (OLD_UTF8 && c2 >= 65536) {
                result[out++] = 63;
                result[out++] = 63;
                continue;
            }
            if (c2 < 128) {
                result[out++] = (byte)c2;
                continue;
            }
            if (!expanded) {
                byte[] newResult = new byte[6 * length];
                System.arraycopy(result, 0, newResult, 0, out);
                result = newResult;
                expanded = true;
            }
            int extraByte = 0;
            if (c2 < 2048) {
                extraByte = 1;
            } else if (c2 < 65536) {
                extraByte = 2;
            } else if (c2 < 0x200000) {
                extraByte = 3;
            } else if (c2 < 0x4000000) {
                extraByte = 4;
            } else if (c2 <= Integer.MAX_VALUE) {
                extraByte = 5;
            } else {
                result[out++] = 63;
                continue;
            }
            int shift = 6 * extraByte;
            byte write = (byte)(254 << 6 - extraByte | c2 >>> shift);
            result[out++] = write;
            for (int j = extraByte - 1; j >= 0; --j) {
                write = (byte)(0x80 | c2 >>> (shift -= 6) & 0x3F);
                result[out++] = write;
            }
        }
        if (expanded) {
            byte[] newResult = new byte[out];
            System.arraycopy(result, 0, newResult, 0, out);
            result = newResult;
        }
        return result;
    }
}

