/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.licenser.checker;

import com.bitegarden.licenser.common.CriptoUtil;
import com.bitegarden.licenser.common.data.DownloadCert;
import com.bitegarden.licenser.common.data.DownloadInfo;
import com.bitegarden.licenser.common.data.LicenseCert;
import com.bitegarden.licenser.common.data.LicenseCertServerID;
import com.bitegarden.licenser.common.data.LicenseStatus;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseChecker {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseChecker.class);
    private static final String DEFAULT_CERT = "/META-INF/cert";
    private static final long MILLISECS_PER_DAY = 86400000L;

    private LicenseChecker() {
    }

    protected static Serializable getLicenseIfValid(DownloadCert downloadCert, String string) {
        LicenseCert licenseCert = (LicenseCert)LicenseChecker.getLicenseCert(downloadCert, string);
        if (licenseCert == null) {
            return null;
        }
        DownloadInfo downloadInfo = downloadCert.getDownloadInfo();
        if (!StringUtils.isBlank(licenseCert.getProductName()) && !StringUtils.isBlank(downloadInfo.getProductName())) {
            String string2 = licenseCert.getProductName().toLowerCase();
            if (downloadInfo.getProductName().equalsIgnoreCase(string2)) {
                if (!(StringUtils.isBlank(licenseCert.getProductVersion()) || StringUtils.isBlank(downloadInfo.getProductVersion()) || downloadInfo.getProductVersion().equals(licenseCert.getProductVersion()))) {
                    Date date = downloadInfo.getPublicationDate();
                    Date date2 = licenseCert.getSupportEndDate();
                    if (date2 == null || date.after(date2)) {
                        return null;
                    }
                }
            } else {
                return null;
            }
        }
        return licenseCert;
    }

    public static LicenseStatus getLicenseStatus(DownloadCert downloadCert, String string) {
        LicenseStatus licenseStatus;
        DownloadInfo downloadInfo = downloadCert.getDownloadInfo();
        Date date = new Date();
        Date date2 = LicenseChecker.getEvalEndDate(downloadInfo);
        boolean bl = date2 != null && !date2.before(date);
        LicenseCert licenseCert = (LicenseCert)LicenseChecker.getLicenseIfValid(downloadCert, string);
        if (licenseCert == null) {
            licenseStatus = bl ? LicenseStatus.EVALUATION : (StringUtils.isBlank(string) && date2 != null ? LicenseStatus.EVALUATION_EXPIRED : LicenseStatus.INVALID_LICENSE);
        } else {
            Comparable<Date> comparable;
            Date date3 = licenseCert.getLicenseEndDate();
            licenseStatus = date3 != null && date3.before(date) ? (bl ? LicenseStatus.EVALUATION : LicenseStatus.LICENSE_EXPIRED) : ((comparable = licenseCert.getSupportEndDate()) != null && !((Date)comparable).before(date) ? LicenseStatus.SUPPORTED : LicenseStatus.LICENSED);
            comparable = licenseCert.getIsEvaluationLicense();
            if (comparable != null && ((Boolean)comparable).booleanValue()) {
                if (licenseStatus == LicenseStatus.LICENSED) {
                    licenseStatus = LicenseStatus.EVALUATION;
                } else if (licenseStatus == LicenseStatus.LICENSE_EXPIRED) {
                    licenseStatus = LicenseStatus.EVALUATION_EXPIRED;
                }
            }
        }
        return licenseStatus;
    }

    public static LicenseStatus getLicenseStatus(String string, String string2) {
        DownloadCert downloadCert = CriptoUtil.strToDownloadCert(string);
        return LicenseChecker.getLicenseStatus(downloadCert, string2);
    }

    public static LicenseStatus getLicenseStatus(String string) {
        DownloadCert downloadCert = LicenseChecker.getDownloadCert();
        return LicenseChecker.getLicenseStatus(downloadCert, string);
    }

    private static DownloadCert getDownloadCert() {
        return LicenseChecker.getDownloadCert(null);
    }

    private static DownloadCert getDownloadCert(String string) {
        String string2 = string == null ? LicenseChecker.getDownloadCertStr() : string;
        return CriptoUtil.strToDownloadCert(string2);
    }

    public static String getDownloadCertStr() {
        return CriptoUtil.readDownloadCertStrFromResource(LicenseChecker.getCertName());
    }

    public static DownloadInfo getDownloadInfo() {
        return LicenseChecker.getDownloadCert().getDownloadInfo();
    }

    public static Serializable getLicenseCert(String string) {
        return LicenseChecker.getLicenseCert(LicenseChecker.getDownloadCert(), string);
    }

    protected static Serializable getLicenseCert(DownloadCert downloadCert, String string) {
        Serializable serializable = null;
        try {
            if (!StringUtils.isBlank(string)) {
                PublicKey publicKey = downloadCert.getKey();
                serializable = CriptoUtil.strToLicenseCert(string, publicKey);
            }
        }
        catch (Exception exception) {
            LOG.debug("Error al intentar desencriptar la licencia", exception);
        }
        return serializable;
    }

    public static String getDownloadKey() {
        return CriptoUtil.readDownloadInfoStrFromResource(LicenseChecker.getCertName());
    }

    private static Date getEvalEndDate(DownloadInfo downloadInfo) {
        Date date = null;
        int n = downloadInfo.getEvaluationPeriodLength();
        if (n > 0) {
            date = DateUtils.addDays(downloadInfo.getDownloadDate(), n);
        }
        return date;
    }

    private static long getDaysLeft(Date date) {
        Date date2 = new Date();
        long l = (date.getTime() - date2.getTime()) / 86400000L;
        return l < 0L ? 0L : l + 1L;
    }

    public static long getUseRemainingDays(String string) {
        return LicenseChecker.getUseRemainingDays(null, string);
    }

    protected static long getUseRemainingDays(String string, String string2) {
        DownloadCert downloadCert = LicenseChecker.getDownloadCert(string);
        Date date = LicenseChecker.getEvalEndDate(downloadCert.getDownloadInfo());
        LicenseCert licenseCert = (LicenseCert)LicenseChecker.getLicenseIfValid(downloadCert, string2);
        if (licenseCert != null) {
            Date date2 = licenseCert.getLicenseEndDate();
            if (date2 == null) {
                return -1L;
            }
            if (date == null || date2.after(date)) {
                date = date2;
            }
        }
        if (date == null) {
            return 0L;
        }
        return LicenseChecker.getDaysLeft(date);
    }

    public static long getSupportRemainingDays(String string) {
        return LicenseChecker.getSupportRemainingDays(null, string);
    }

    protected static long getSupportRemainingDays(String string, String string2) {
        DownloadCert downloadCert = LicenseChecker.getDownloadCert(string);
        Date date = null;
        LicenseCert licenseCert = (LicenseCert)LicenseChecker.getLicenseIfValid(downloadCert, string2);
        if (licenseCert != null) {
            date = licenseCert.getSupportEndDate();
        }
        if (date == null) {
            return 0L;
        }
        return LicenseChecker.getDaysLeft(date);
    }

    public static String getServerId(String string, String string2) {
        String string3 = null;
        DownloadCert downloadCert = LicenseChecker.getDownloadCert(string);
        Serializable serializable = LicenseChecker.getLicenseIfValid(downloadCert, string2);
        if (serializable instanceof LicenseCertServerID) {
            string3 = ((LicenseCertServerID)serializable).getServerId();
        }
        return string3;
    }

    public static String getServerId(String string) {
        return LicenseChecker.getServerId(null, string);
    }

    private static String getCertName() {
        return DEFAULT_CERT;
    }
}

