/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public final class ResourceUtil {
    private static final String DEFAULT_ENCODING = "utf-8";

    private ResourceUtil() {
    }

    public static String loadTextFromClasspathResource(String string, Class<?> clazz, String string2) {
        Class clazz2 = clazz == null ? ResourceUtil.class : clazz;
        InputStream inputStream = clazz2.getResourceAsStream(string);
        try {
            if (inputStream == null) {
                throw new IllegalArgumentException("File doesn't exist " + string);
            }
            String string3 = StringUtils.isBlank(string2) ? DEFAULT_ENCODING : string2;
            String string4 = IOUtils.toString(inputStream, string3);
            return string4;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Can not read the file " + string, iOException);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static String loadTextFromClasspathResource(String string) {
        return ResourceUtil.loadTextFromClasspathResource(string, null, null);
    }

    public static String loadTextFromAbsolutePath(String string, String string2) {
        File file = new File(string);
        if (file.exists()) {
            try {
                return FileUtils.readFileToString(file, string2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Can not read the file " + string, iOException);
            }
        }
        throw new IllegalArgumentException("File doesn't exist " + string);
    }

    public static String loadTextFromAbsolutePath(String string) {
        return ResourceUtil.loadTextFromAbsolutePath(string, null);
    }
}

