/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.cache;

import es.sonarqube.cache.Cache;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCache
implements Cache {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryCache.class);
    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();

    @Override
    public void add(String string, Object object) {
        if (string == null || object == null) {
            LOG.debug("All arguments are required");
            return;
        }
        this.cache.put(string, object);
        LOG.debug("Object added to cache with key {}", (Object)string);
    }

    @Override
    public void remove(String string) {
        LOG.debug("Removing cache object {}", (Object)string);
        this.cache.remove(string);
        LOG.debug("Cache object {} removed successfully", (Object)string);
    }

    @Override
    public Object get(String string) {
        return this.cache.get(string);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public long size() {
        return this.cache.size();
    }
}

