/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import java.util.List;

public class SonarQubeURLManager {
    private static final String MULTIPROJECT_ISSUES = "issues/search#resolved=false|rules=";
    private static final String MULTIPROJECT_ISSUES_6_5 = "issues?projectUuids=";
    private static final String MULTIPROJECT_ISSUES_7_9 = "issues?projects=";
    private static final String ISSUES = "component_issues?id=";
    private static final String ISSUES_6_5 = "project/issues?id=";
    private static final String MEASURES = "component_measures/metric/";
    private static final String HOTSPOTS = "component_security_hotspots?id=";
    private static final String HOTSPOTS_6_5 = "security_hotspots?id=";
    private static final String SONARCLOUD_HOTSPOTS = "project/security_hotspots?id=";

    private SonarQubeURLManager() {
    }

    public static String getIssuesUrl(String string, String string2, String string3, String string4) {
        return SonarQubeURLManager.getIssuesUrl(string, string2, string3, string4, "");
    }

    public static String getIssuesUrl(String string, String string2, String string3, String string4, String string5) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        if (string3.startsWith("5.") || string3.startsWith("6.3") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
            if (string5 != null && !string5.isEmpty()) {
                return string + ISSUES + string2 + "#resolved=false&rules=" + string4 + "&branch=" + string5;
            }
            return string + ISSUES + string2 + "#resolved=false&rules=" + string4;
        }
        if (string5 != null && !string5.isEmpty()) {
            return string + ISSUES_6_5 + string2 + "&resolved=false&rules=" + string4 + "&branch=" + string5;
        }
        return string + ISSUES_6_5 + string2 + "&resolved=false&rules=" + string4;
    }

    public static String getHotSpotsUrl(String string, String string2, String string3, String string4) {
        if ((string = SonarQubeURLManager.addUrlForwardSlash(string)).contains("sonarcloud.io")) {
            if (string4 != null && !string4.isEmpty()) {
                return string + SONARCLOUD_HOTSPOTS + string2 + "&branch=" + string4;
            }
            return string + SONARCLOUD_HOTSPOTS + string2;
        }
        if (string3.startsWith("5.") || string3.startsWith("6.3") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
            if (string4 != null && !string4.isEmpty()) {
                return string + HOTSPOTS + string2 + "&branch=" + string4;
            }
            return string + HOTSPOTS + string2;
        }
        if (string4 != null && !string4.isEmpty()) {
            return string + HOTSPOTS_6_5 + string2 + "&branch=" + string4;
        }
        return string + HOTSPOTS_6_5 + string2;
    }

    public static String getIssuesUrlByType(String string, String string2, String string3, String string4, String string5) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        if (string3.startsWith("5.") || string3.startsWith("6.3") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
            if (string5 != null && !string5.isEmpty()) {
                return string + ISSUES + string2 + "#resolved=false&types=" + string4 + "&branch=" + string5;
            }
            return string + ISSUES + string2 + "#resolved=false&types=" + string4;
        }
        if (string5 != null && !string5.isEmpty()) {
            return string + ISSUES_6_5 + string2 + "&resolved=false&types=" + string4 + "&branch=" + string5;
        }
        return string + ISSUES_6_5 + string2 + "&resolved=false&types=" + string4;
    }

    public static String getIssuesUrlBySeverity(String string, String string2, String string3, String string4, String string5) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        if (string3.startsWith("5.") || string3.startsWith("6.3") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
            if (string5 != null && !string5.isEmpty()) {
                return string + ISSUES + string2 + "#resolved=false&severities=" + string4 + "&branch=" + string5;
            }
            return string + ISSUES + string2 + "#resolved=false&severities=" + string4;
        }
        if (string5 != null && !string5.isEmpty()) {
            return string + ISSUES_6_5 + string2 + "&resolved=false&severities=" + string4 + "&branch=" + string5;
        }
        return string + ISSUES_6_5 + string2 + "&resolved=false&severities=" + string4;
    }

    public static String getIssuesMultiProjectUrl(String string, List<String> list, List<String> list2, String string2, String string3) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        String string4 = String.join((CharSequence)",", list2);
        String string5 = String.join((CharSequence)",", list);
        if (string2.startsWith("5.") || string2.startsWith("6.3") || string2.startsWith("6.2") || string2.startsWith("6.1") || string2.startsWith("6.0")) {
            return string + MULTIPROJECT_ISSUES + string3 + "|projectUuids=" + string4;
        }
        if (string2.startsWith("6.4") || string2.startsWith("6.5") || string2.startsWith("6.6") || string2.startsWith("6.7")) {
            return string + MULTIPROJECT_ISSUES_6_5 + string4 + "&resolved=false&rules=" + string3;
        }
        return string + MULTIPROJECT_ISSUES_7_9 + string5 + "&resolved=false&rules=" + string3;
    }

    public static String getBugsUrl(String string, String string2, String string3) {
        return SonarQubeURLManager.getBugsUrl(string, string2, string3, "");
    }

    public static String getBugsUrl(String string, String string2, String string3, String string4) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        if (string3.startsWith("5.") || string3.startsWith("6.3") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
            if (string4 != null && !string4.isEmpty()) {
                return string + ISSUES + string2 + "#resolved=false|types=BUG&branch=" + string4;
            }
            return string + ISSUES + string2 + "#resolved=false|types=BUG";
        }
        if (string4 != null && !string4.isEmpty()) {
            return string + ISSUES_6_5 + string2 + "&resolved=false&types=BUG&branch=" + string4;
        }
        return string + ISSUES_6_5 + string2 + "&resolved=false&types=BUG";
    }

    public static String getVulnerabilitiesUrl(String string, String string2, String string3) {
        return SonarQubeURLManager.getVulnerabilitiesUrl(string, string2, string3, "");
    }

    public static String getVulnerabilitiesUrl(String string, String string2, String string3, String string4) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        if (string3.startsWith("5.") || string3.startsWith("6.3") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
            if (string4 != null && !string4.isEmpty()) {
                return string + ISSUES + string2 + "#resolved=false|types=VULNERABILITY&branch=" + string4;
            }
            return string + ISSUES + string2 + "#resolved=false|types=VULNERABILITY";
        }
        if (string4 != null && !string4.isEmpty()) {
            return string + ISSUES_6_5 + string2 + "&resolved=false&types=VULNERABILITY&branch=" + string4;
        }
        return string + ISSUES_6_5 + string2 + "&resolved=false&types=VULNERABILITY";
    }

    public static String getCodeSmellsUrl(String string, String string2, String string3) {
        return SonarQubeURLManager.getCodeSmellsUrl(string, string2, string3, "");
    }

    public static String getCodeSmellsUrl(String string, String string2, String string3, String string4) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        if (string3.startsWith("5.") || string3.startsWith("6.3") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
            if (string4 != null && !string4.isEmpty()) {
                return string + ISSUES + string2 + "#resolved=false|types=CODE_SMELL&branch=" + string4;
            }
            return string + ISSUES + string2 + "#resolved=false|types=CODE_SMELL";
        }
        if (string4 != null && !string4.isEmpty()) {
            return string + ISSUES_6_5 + string2 + "&resolved=false&types=CODE_SMELL&branch=" + string4;
        }
        return string + ISSUES_6_5 + string2 + "&resolved=false&types=CODE_SMELL";
    }

    public static String getMeasureUrl(String string, String string2, String string3) {
        return SonarQubeURLManager.getMeasureUrl(string, string2, string3, "");
    }

    public static String getMeasureUrl(String string, String string2, String string3, String string4) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        if (string4 != null && !string4.isEmpty()) {
            return string + MEASURES + string3 + "/list?id=" + string2 + "&branch=" + string4;
        }
        return string + MEASURES + string3 + "/list?id=" + string2;
    }

    public static String getProjectUrl(String string, String string2, String string3) {
        return SonarQubeURLManager.getProjectUrl(string, string2, string3, "");
    }

    public static String getProjectUrl(String string, String string2, String string3, String string4) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        if (string3.startsWith("5.") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
            if (string4 != null && !string4.isEmpty()) {
                return string + "overview?id=" + string2 + "&branch=" + string4;
            }
            return string + "overview?id=" + string2;
        }
        if (string4 != null && !string4.isEmpty()) {
            return string + "dashboard?id=" + string2 + "&branch=" + string4;
        }
        return string + "dashboard?id=" + string2;
    }

    public static String getTotalIssuesByAuthorUrl(String string, String string2, List<String> list, List<String> list2, String string3) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        String string4 = String.join((CharSequence)",", list2);
        String string5 = String.join((CharSequence)",", list);
        if (!list.isEmpty()) {
            if (string3.startsWith("5.") || string3.startsWith("6.3") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
                return string + "issues/search#resolved=false|authors=" + string2 + "|projectUuids=" + string4;
            }
            if (string3.startsWith("6.4") || string3.startsWith("6.5") || string3.startsWith("6.6") || string3.startsWith("6.7")) {
                return string + MULTIPROJECT_ISSUES_6_5 + string4 + "&resolved=false&authors=" + string2;
            }
            return string + MULTIPROJECT_ISSUES_7_9 + string5 + "&resolved=false&authors=" + string2;
        }
        return string + "issues?authors=" + string2 + "&resolved=false";
    }

    public static String getTotalIssuesByAuthorAndSeverityUrl(String string, List<String> list, List<String> list2, String string2, String string3, String string4) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        String string5 = String.join((CharSequence)",", list2);
        String string6 = String.join((CharSequence)",", list);
        if (!list.isEmpty()) {
            if (string3.startsWith("5.") || string3.startsWith("6.3") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
                return string + "issues/search#resolved=false|authors=" + string2 + "|projectUuids=" + string5 + "|severities=" + string4;
            }
            if (string3.startsWith("6.4") || string3.startsWith("6.5") || string3.startsWith("6.6") || string3.startsWith("6.7")) {
                return string + MULTIPROJECT_ISSUES_6_5 + string5 + "&resolved=false&authors=" + string2 + "&severities=" + string4;
            }
            return string + MULTIPROJECT_ISSUES_7_9 + string6 + "&resolved=false&authors=" + string2 + "&severities=" + string4;
        }
        return string + "issues?authors=" + string2 + "&severities=" + string4 + "&resolved=false";
    }

    public static String getTotalIssuesByAuthorAndTypeUrl(String string, List<String> list, List<String> list2, String string2, String string3, String string4) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        String string5 = String.join((CharSequence)",", list2);
        String string6 = String.join((CharSequence)",", list);
        if (!list.isEmpty()) {
            if (string3.startsWith("5.") || string3.startsWith("6.3") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
                return string + "issues/search#resolved=false|authors=" + string2 + "|projectUuids=" + string5 + "|types=" + string4;
            }
            if (string3.startsWith("6.4") || string3.startsWith("6.5") || string3.startsWith("6.6") || string3.startsWith("6.7")) {
                return string + MULTIPROJECT_ISSUES_6_5 + string5 + "&resolved=false&authors=" + string2 + "&types=" + string4;
            }
            return string + MULTIPROJECT_ISSUES_7_9 + string6 + "&resolved=false&authors=" + string2 + "&types=" + string4;
        }
        return string + "issues?authors=" + string2 + "&resolved=false&types=" + string4;
    }

    public static String getIssuesByAuthorUrl(String string, List<String> list, List<String> list2, String string2, String string3, String string4, String string5, String string6, String string7) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        String string8 = String.join((CharSequence)",", list2);
        String string9 = String.join((CharSequence)",", list);
        if (string3.startsWith("5.") || string3.startsWith("6.3") || string3.startsWith("6.2") || string3.startsWith("6.1") || string3.startsWith("6.0")) {
            return string + "issues/search#resolved=false|authors=" + string2 + "|projectUuids=" + string8 + "|types=" + string4 + "|severities=" + string5 + "|branch=" + string7;
        }
        if (string3.startsWith("6.4") || string3.startsWith("6.5") || string3.startsWith("6.6") || string3.startsWith("6.7")) {
            return string + MULTIPROJECT_ISSUES_6_5 + string8 + "&resolved=false&authors=" + string2 + "&severities=" + string5 + "&types=" + string4 + "&rules=" + string6 + "&branch=" + string7;
        }
        return string + MULTIPROJECT_ISSUES_7_9 + string9 + "&resolved=false&authors=" + string2 + "&severities=" + string5 + "&types=" + string4 + "&rules=" + string6 + "&branch=" + string7;
    }

    public static String getUrlBySeverity(String string, String string2, String string3, String string4, String string5) {
        string = SonarQubeURLManager.addUrlForwardSlash(string);
        if (string4.startsWith("5.") || string4.startsWith("6.3") || string4.startsWith("6.2") || string4.startsWith("6.1") || string4.startsWith("6.0")) {
            if (string5 != null && !string5.isEmpty()) {
                return string + ISSUES + string2 + "#resolved=false|severities=" + string3 + "&branch=" + string5;
            }
            return string + ISSUES + string2 + "#resolved=false|severities=" + string3;
        }
        if (string5 != null && !string5.isEmpty()) {
            return string + ISSUES_6_5 + string2 + "&resolved=false&severities" + string3 + "&branch=" + string5;
        }
        return string + ISSUES_6_5 + string2 + "&resolved=false&severities=" + string3;
    }

    private static String addUrlForwardSlash(String string) {
        if (string != null && !string.endsWith("/")) {
            return string + "/";
        }
        return string;
    }
}

