/*
 * Decompiled with CFR 0.152.
 */
package com.bitegarden.sonar.plugins.report;

import com.bitegarden.license.utils.BitegardenLicenseChecker;
import com.bitegarden.sonar.plugins.report.pdf.ReportEngine;
import com.bitegarden.sonar.plugins.report.util.ReportUtils;
import com.bitegarden.sonar.plugins.report.xlsx.XlsxReport;
import es.sonarqube.exceptions.SonarQubeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;

public class CommandLine {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLine.class);
    private static final String REPORT_CONFIGURATION_PROPERTY = "config.file";
    private static final String SONARQUBE_LICENSE_FILE_PROPERTY = "license.file";
    private static final String SONARQUBE_TOKEN_PROPERTY = "sonar.token";
    private static final String SONARQUBE_PROJECT_PROPERTY = "sonar.projectKey";
    private static final String REPORT_TYPE_PROPERTY = "report.type";
    private static final String SONARQUBE_BRANCH_PROPERTY = "sonar.branch";
    private static final String SONARQUBE_ORGANIZATION_PROPERTY = "sonar.organizationKey";
    private static final String USER_LOCALE_PROPERTY = "user.locale";
    private static final String DISABLE_QUALITYGATE_PROPERTY = "disable.qualitygate";
    private static final String DISABLE_COVERAGE_PROPERTY = "disable.coverage";
    private static final String FOOTER_LOGO_URL = "footer.url";
    private static final String SONARCLOUD_URL = "https://sonarcloud.io";
    private static final String OUTPUT_FILENAME_PROPERTY = "output";
    private static final String[] REPORT_TYPE_DESCRIPTION = new String[]{"executive-summary", "issues-breakdown-summary", "issues-breakdown-full", "excel-report"};
    private static final String TEMPLATE_SUMMARY_FILE_PROPERTY = "template.summary.file";
    private static final String TEMPLATE_ISSUES_FILE_PROPERTY = "template.issues.file";
    private static final String DEFAULT_TEMPLATE_PDF = "/static/templates/default-template.pdf";
    private static BitegardenLicenseChecker checker;
    private static ResourceBundle i18n;

    public static void main(String[] stringArray) {
        block25: {
            Object object;
            String string;
            CommandLine.printCommandLineHeader();
            if (stringArray.length == 1) {
                CommandLine.printCommandLineHelp();
                return;
            }
            if (stringArray.length > 1) {
                CommandLine.printCommandSuggestion(stringArray);
                return;
            }
            Properties properties = CommandLine.loadConfiguration();
            String string2 = properties.getProperty(SONARQUBE_LICENSE_FILE_PROPERTY);
            String string3 = "";
            if (string2 != null) {
                string3 = CommandLine.loadLicenseFile(string2);
            } else {
                LOGGER.warn("license.file property is empty. Using trial version.");
            }
            String string4 = properties.getProperty(SONARQUBE_TOKEN_PROPERTY);
            if (string4 == null || "".equals(string4.trim())) {
                LOGGER.warn("sonar.token property is empty. Using anonymous access to SonarCloud.");
                string4 = "";
            }
            if ((string = properties.getProperty(SONARQUBE_ORGANIZATION_PROPERTY)) == null || "".equals(string.trim())) {
                LOGGER.warn("sonar.organizationKey property is empty. Report generation may fail!");
                string = "";
            }
            checker = new BitegardenLicenseChecker("bitegardenReportCloud", string3, string);
            CommandLine.printLicenseInformation();
            if (checker.isEvaluationLicense()) {
                object = checker.getEvaluationDays();
                LOGGER.info("");
                LOGGER.info("You are using a trial version ( {} days left ).  This trial version will expire soon. Please, consider purchasing the full version at www.bitegarden.com", object);
            } else if (!checker.isValidLicense()) {
                LOGGER.info("");
                LOGGER.info("License is not valid. Contact us at www.bitegarden.com / mailto:support@bitegarden.com");
                LOGGER.info("");
                System.exit(-1);
            }
            object = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(SONARCLOUD_URL).token(string4).build());
            String string5 = properties.getProperty(SONARQUBE_PROJECT_PROPERTY);
            if (string5 == null || "".equals(string5.trim())) {
                LOGGER.error("SonarCloud project key is empty. You must provide a project key to generate reports. Please, provide the project key using the 'sonar.projectKey'  property through command line or config file");
                LOGGER.error("");
                System.exit(-1);
            }
            LOGGER.info("");
            LOGGER.info("------------< Generating SonarCloud Report >--------------");
            LOGGER.info("Project Key:     {}", (Object)string5);
            Integer n = Integer.parseInt(properties.getProperty(REPORT_TYPE_PROPERTY, "0"));
            if (n > REPORT_TYPE_DESCRIPTION.length - 1) {
                LOGGER.info("Report type {} is not available. Using default type", (Object)n);
                n = 0;
            }
            LOGGER.info("Report Type:     {} ({}) ", (Object)n, (Object)REPORT_TYPE_DESCRIPTION[n]);
            LOGGER.info("");
            String string6 = properties.getProperty(SONARQUBE_BRANCH_PROPERTY);
            if (string6 == null || "".equals(string6)) {
                LOGGER.info("No branch selected. Data will be retrieved from main branch.");
            } else {
                LOGGER.info("Branch:               {}                    (if it does not exists it will be retrieved from main branch)", (Object)string6);
            }
            Boolean bl = Boolean.parseBoolean(properties.getProperty(DISABLE_QUALITYGATE_PROPERTY, "false"));
            LOGGER.info("Disable quality gate: {} ", (Object)bl);
            Boolean bl2 = Boolean.parseBoolean(properties.getProperty(DISABLE_COVERAGE_PROPERTY, "false"));
            LOGGER.info("Disable coverage:     {} ", (Object)bl2);
            String string7 = properties.getProperty(FOOTER_LOGO_URL);
            LOGGER.info("");
            if (string7 == null || "".equals(string7)) {
                LOGGER.info("No footer URL found. Default logo will be used");
                string7 = "";
            } else {
                LOGGER.info("Footer Logo URL: {}", (Object)string7);
            }
            LOGGER.info("");
            String string8 = properties.getProperty(USER_LOCALE_PROPERTY);
            Locale locale = Locale.getDefault();
            if (string8 == null) {
                LOGGER.info("User locale is null. Using default: {}", (Object)locale.getDisplayName());
            } else if (string8.equals("es")) {
                locale = new Locale("es", "ES");
            } else if (string8.equals("en")) {
                locale = new Locale("en", "UK");
            }
            Locale.setDefault(Locale.ENGLISH);
            i18n = ResourceBundle.getBundle("org.sonar.l10n.bitegardenReport", locale);
            LOGGER.info("User locale: {} {}", (Object)locale.getLanguage(), (Object)locale.getCountry());
            String string9 = properties.getProperty(OUTPUT_FILENAME_PROPERTY);
            if (checker.isValidLicense()) {
                try {
                    if (n == 3) {
                        LOGGER.info("");
                        LOGGER.info("Generating Excel...");
                        XlsxReport.generateXlsx(string5, string6, string4, locale, string9, checker.isEvaluationLicense());
                        break block25;
                    }
                    CommandLine.generatePdf(n, string5, string6, locale, bl, bl2, string7, (WsClient)object, string9);
                }
                catch (SonarQubeException sonarQubeException) {
                    LOGGER.error("Error generating Excel: {}", (Object)sonarQubeException.getMessage(), (Object)sonarQubeException);
                }
            } else {
                LOGGER.error("License is not valid: {}", (Object)checker.getLicenseStatus());
                LOGGER.error("Unable to generate reports.");
                System.exit(-1);
            }
        }
        System.exit(0);
    }

    private static void generatePdf(Integer n, String string, String string2, Locale locale, boolean bl, boolean bl2, String string3, WsClient wsClient, String string4) throws SonarQubeException {
        String string5 = i18n.getString(TEMPLATE_SUMMARY_FILE_PROPERTY);
        String string6 = i18n.getString(TEMPLATE_ISSUES_FILE_PROPERTY);
        try (PDDocument pDDocument = PDDocument.load(CommandLine.class.getResourceAsStream(string5));
             PDDocument pDDocument2 = PDDocument.load(CommandLine.class.getResourceAsStream(string6));
             PDDocument pDDocument3 = PDDocument.load(CommandLine.class.getResourceAsStream(DEFAULT_TEMPLATE_PDF));){
            boolean bl3 = checker.isEvaluationLicense();
            Instant instant = Instant.now();
            ReportEngine reportEngine = new ReportEngine(pDDocument3, pDDocument, pDDocument2, string, string2, locale, bl, bl2, string3, wsClient, bl3);
            LOGGER.info("");
            LOGGER.info("Generating PDF...");
            switch (n) {
                case 1: {
                    reportEngine.generateIssuesBreakdownReport();
                    break;
                }
                case 2: {
                    reportEngine.generateFullIssuesBreakdownReport();
                    break;
                }
                default: {
                    reportEngine.generateExecutiveReport();
                }
            }
            Instant instant2 = Instant.now();
            Double d2 = (double)Duration.between(instant, instant2).toMillis() / 1000.0;
            LOGGER.info("PDF {} generated for {} ( Total elapsed time: {} s )", REPORT_TYPE_DESCRIPTION[n], string, d2);
            String string7 = string.replace(':', '-') + "-" + REPORT_TYPE_DESCRIPTION[n] + ".pdf";
            if (string4 != null) {
                string7 = string4;
            }
            pDDocument3.save(string7);
            LOGGER.info("Output file: {}", (Object)string7);
            LOGGER.info("");
        }
        catch (IOException iOException) {
            LOGGER.error("Unable to generate PDF", iOException);
        }
    }

    private static void printCommandLineHeader() {
        String string = ReportUtils.getVersion();
        LOGGER.info("");
        LOGGER.info("bitegarden Report for SonarCloud ({}). Copyright (C) 2021 bitegarden. All rights reserved. www.bitegarden.com", (Object)string);
        LOGGER.info("Documentation available at https://www.bitegarden.com/sonarcloud-report");
        LOGGER.info("");
    }

    private static void printCommandSuggestion(String[] stringArray) {
        LOGGER.info("Found wrong additional arguments:");
        LOGGER.info("");
        LOGGER.info("      java -jar bitegarden-sonarcloud-report-1.0.1.jar {} {} ...", (Object)stringArray[0], (Object)stringArray[1]);
        LOGGER.info("");
        LOGGER.info("Are you sure? Maybe you should try with: ");
        LOGGER.info("");
        LOGGER.info("      java {} {} ... -jar bitegarden-sonarcloud-report-1.0.1.jar ", (Object)stringArray[0], (Object)stringArray[1]);
        LOGGER.info("");
    }

    private static void printCommandLineHelp() {
        LOGGER.info("bitegarden Report for SonarCloud. Command Line usage:");
        LOGGER.info("");
        LOGGER.info("java -Dconfig.file=PATH_TO_CONFIG_FILE -Dlicense.file=PATH_TO_LICENSE_FILE ... -jar sonarcloud-report-cli.jar");
        LOGGER.info("");
        LOGGER.info("          config.file = path to properties file including all the parameters required to generate the reports. ");
        LOGGER.info("                        This is optional. You can set all the properties through command line args using -DpropertyName=propertyValue");
        LOGGER.info("                        Note that if you use a config file and command line arguments, arguments will override config file");
        LOGGER.info("");
        LOGGER.info("         license.file = path to file with your license key provided by bitegarden.");
        LOGGER.info("                        By default a 14 days trial version will be used if license file is not provided");
        LOGGER.info("");
        LOGGER.info("Mandatory properties:");
        LOGGER.info("");
        LOGGER.info("           sonar.token = your user security token to authenticate against SonarCloud.");
        LOGGER.info("                         It is recommended to generate a new token for this app.");
        LOGGER.info("      sonar.projectKey = the project key from SonarQube. You can find it in SonarQube project information");
        LOGGER.info(" sonar.organizationKey = the SonarCloud organization the project belongs to");
        LOGGER.info("           report.type = 0 (executive summary) Default value");
        LOGGER.info("                         1 (issues summary) ");
        LOGGER.info("                         2 (full issues breakdown)");
        LOGGER.info("                         3 (excel report)");
        LOGGER.info("");
        LOGGER.info("Optional properties:");
        LOGGER.info("");
        LOGGER.info("          sonar.branch = the branch where we will get the information for the report (default is main branch)");
        LOGGER.info(" * disable.qualitygate = If you enable this option the quality gate status won't be displayed (default is false)");
        LOGGER.info("    * disable.coverage = If you enable this option the coverage section in the summary page won't be displayed (default is false)");
        LOGGER.info("          * footer.url = URL of the image to display centered in footer (PNG or JPG format are supported)");
        LOGGER.info("                         If image height is bigger than 25px it will be resized. ");
        LOGGER.info("           user.locale = Locale to use for generated PDF or Excel file. Options are English (user.locale=en) or Spanish (user.locale=es)");
        LOGGER.info("                output = File name for the generated report");
        LOGGER.info("");
        LOGGER.info("* Properties only supported on PDF report");
        LOGGER.info("");
        LOGGER.info("More information at https://www.bitegarden.com/sonarcloud-report#usage ");
        LOGGER.info("");
    }

    private static void printLicenseInformation() {
        LOGGER.info("");
        LOGGER.info("-----------------< License Information >------------------");
        String string = checker.getLicenseStatus().name();
        String string2 = checker.getDownloadInfo().getCustomerCompany();
        LOGGER.info("Status:                            {}", (Object)string);
        LOGGER.info("Company:                           {}", (Object)string2);
        String string3 = checker.getLicensedServerId() == null ? "-" : checker.getLicensedServerId();
        LOGGER.info("Licensed SonarCloud Organization:  {}", (Object)string3);
        LOGGER.info("Expiration Date:                   {}", (Object)ReportUtils.getExpirationDateFromRemainingDays(checker.getUseRemainingDays()));
        LOGGER.info("Remaining Days:                    {}", (Object)checker.getUseRemainingDays());
    }

    private static void printConfiguration(Properties properties) {
        Set<String> set = properties.stringPropertyNames();
        if (!properties.isEmpty()) {
            LOGGER.info("---------------< Configuration properties >---------------");
            LOGGER.info("java.version = {}", (Object)System.getProperty("java.version"));
        }
        for (String string : set) {
            if (string.equals(SONARQUBE_TOKEN_PROPERTY)) {
                if (properties.getProperty(string).isEmpty()) continue;
                LOGGER.info("{} = ******** (value is hidden for security reasons)", (Object)string);
                continue;
            }
            LOGGER.info("{} = {}", (Object)string, (Object)properties.getProperty(string));
        }
    }

    private static String loadLicenseFile(String string) {
        String string2 = "";
        try (Scanner scanner = new Scanner(new File(string));){
            string2 = scanner.useDelimiter("\\Z").next();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.error("License file not found: {}", (Object)fileNotFoundException.getMessage(), (Object)fileNotFoundException);
            System.exit(-1);
        }
        return string2;
    }

    private static Properties loadConfiguration() {
        Properties properties = new Properties();
        String string = System.getProperty(REPORT_CONFIGURATION_PROPERTY);
        if (string != null) {
            try (FileInputStream fileInputStream = new FileInputStream(string);){
                LOGGER.info("Reading configuration file: {}", (Object)string);
                properties.load(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.warn("Configuration file not found: {}", (Object)fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                LOGGER.warn("IOException when loading configuration file: {}", (Object)iOException.getMessage());
            }
        }
        LOGGER.info("Loading properties from command line (-Dname=value)... if found, it will override configuration file properties");
        if (System.getProperty(SONARQUBE_LICENSE_FILE_PROPERTY) != null) {
            properties.put(SONARQUBE_LICENSE_FILE_PROPERTY, System.getProperty(SONARQUBE_LICENSE_FILE_PROPERTY));
        }
        if (System.getProperty(SONARQUBE_TOKEN_PROPERTY) != null) {
            properties.put(SONARQUBE_TOKEN_PROPERTY, System.getProperty(SONARQUBE_TOKEN_PROPERTY));
        }
        if (System.getProperty(SONARQUBE_ORGANIZATION_PROPERTY) != null) {
            properties.put(SONARQUBE_ORGANIZATION_PROPERTY, System.getProperty(SONARQUBE_ORGANIZATION_PROPERTY));
        }
        if (System.getProperty(SONARQUBE_PROJECT_PROPERTY) != null) {
            properties.put(SONARQUBE_PROJECT_PROPERTY, System.getProperty(SONARQUBE_PROJECT_PROPERTY));
        }
        if (System.getProperty(REPORT_TYPE_PROPERTY) != null) {
            properties.put(REPORT_TYPE_PROPERTY, System.getProperty(REPORT_TYPE_PROPERTY));
        }
        if (System.getProperty(SONARQUBE_BRANCH_PROPERTY) != null) {
            properties.put(SONARQUBE_BRANCH_PROPERTY, System.getProperty(SONARQUBE_BRANCH_PROPERTY));
        }
        if (System.getProperty(DISABLE_QUALITYGATE_PROPERTY) != null) {
            properties.put(DISABLE_QUALITYGATE_PROPERTY, System.getProperty(DISABLE_QUALITYGATE_PROPERTY));
        }
        if (System.getProperty(DISABLE_COVERAGE_PROPERTY) != null) {
            properties.put(DISABLE_COVERAGE_PROPERTY, System.getProperty(DISABLE_COVERAGE_PROPERTY));
        }
        if (System.getProperty(FOOTER_LOGO_URL) != null) {
            properties.put(FOOTER_LOGO_URL, System.getProperty(FOOTER_LOGO_URL));
        }
        if (System.getProperty(USER_LOCALE_PROPERTY) != null) {
            properties.put(USER_LOCALE_PROPERTY, System.getProperty(USER_LOCALE_PROPERTY));
        }
        if (System.getProperty(OUTPUT_FILENAME_PROPERTY) != null) {
            properties.put(OUTPUT_FILENAME_PROPERTY, System.getProperty(OUTPUT_FILENAME_PROPERTY));
        }
        if (properties.isEmpty()) {
            LOGGER.error("No configuration found.");
            LOGGER.info("");
            CommandLine.printCommandLineHelp();
            System.exit(-1);
        }
        LOGGER.info("Configuration loaded.");
        LOGGER.info("");
        CommandLine.printConfiguration(properties);
        return properties;
    }
}

