/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import es.sonarqube.api.SonarQubeApplication;
import es.sonarqube.api.SonarQubeHotspotCategory;
import es.sonarqube.api.SonarQubeHotspotsBreakdown;
import es.sonarqube.api.SonarQubeHotspotsPerCategory;
import es.sonarqube.api.SonarQubePortfolio;
import es.sonarqube.api.SonarQubeProject;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeRuleManager;
import es.sonarqube.managers.SonarQubeServerManager;
import es.sonarqube.managers.SonarQubeURLManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Hotspots;
import org.sonarqube.ws.Issues;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.hotspots.SearchRequest;
import org.sonarqube.ws.client.hotspots.ShowRequest;

public class SonarQubeHotspotManager {
    private static final String SONARCLOUD_URL = "https://sonarcloud.io";
    private static final String TO_REVIEW = "TO_REVIEW";
    private static final String RULES = "rules";
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeHotspotManager.class);
    private static final String OTHERS_CATEGORY_KEY = "others";
    private static final String PS_PARAMETER = "500";
    private final WsClient wsClient;

    protected static SonarQubeHotspotsBreakdown getSonarQubeHotspotsBreakdown(WsClient wsClient, String string, String string2) {
        return new SonarQubeHotspotManager(wsClient).getSonarQubeHotspotsBreakdown(string, string2);
    }

    protected static SonarQubeHotspotsBreakdown getAllSonarQubeHotspotsBreakdown(WsClient wsClient, String string, String string2) {
        return new SonarQubeHotspotManager(wsClient).getAllSonarQubeHotspotsBreakdown(string, string2);
    }

    protected static SonarQubeHotspotsBreakdown getSonarQubeHotspotsBreakdown(WsClient wsClient, List<String> list) {
        return new SonarQubeHotspotManager(wsClient).getSonarQubeHotspotsBreakdown(list);
    }

    protected static SonarQubeHotspotsBreakdown getAllSonarQubeHotspotsBreakdown(WsClient wsClient, List<String> list) {
        return new SonarQubeHotspotManager(wsClient).getAllSonarQubeHotspotsBreakdown(list);
    }

    public SonarQubeHotspotManager(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public SonarQubeHotspotManager(String string, String string2) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    public Map<String, Long> getSecurityHotspotsByRule(SonarQubeProject sonarQubeProject2, String string) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        switch (sonarQubeProject2.getSonarQubeQualifier()) {
            case PROJECT: {
                return this.getSecurityHotspotsByRule(sonarQubeProject2.getKey(), string);
            }
            case APPLICATION: {
                ((SonarQubeApplication)sonarQubeProject2).getProjects().forEach(sonarQubeProject -> {
                    Map<String, Long> map2 = this.getSecurityHotspotsByRule(sonarQubeProject.getKey(), sonarQubeProject.getBranchName());
                    map2.forEach((string, l) -> hashMap.put((String)string, hashMap.getOrDefault(string, 0L) + l));
                });
                break;
            }
            case PORTFOLIO: {
                ((SonarQubePortfolio)sonarQubeProject2).getSonarQubeProjectList().forEach(sonarQubeProject -> {
                    Map<String, Long> map2 = this.getSecurityHotspotsByRule(sonarQubeProject.getKey(), string);
                    map2.forEach((string, l) -> hashMap.put((String)string, hashMap.getOrDefault(string, 0L) + l));
                });
                break;
            }
        }
        return this.sortByValue(hashMap);
    }

    public Map<String, Long> getSecurityHotspotsByRule(String string) {
        return this.getSecurityHotspotsByRule(string, null);
    }

    public Map<String, Long> getSecurityHotspotsByRule(String string, String string2) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        String string3 = "7.9";
        try {
            string3 = SonarQubeServerManager.getSonarQubeVersion(this.wsClient);
        }
        catch (SonarQubeException sonarQubeException) {
            LOGGER.error("Unable to get SonarQube version from server: {}", (Object)sonarQubeException.getMessage(), (Object)sonarQubeException);
            LOGGER.warn("We will use {} LTS to retrieve hotsposts", (Object)string3);
        }
        int n = Integer.parseInt(string3.substring(0, 1));
        int n2 = Integer.parseInt(string3.substring(2, 3));
        boolean bl = SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl());
        boolean bl2 = n > 8 || n == 8 && n2 >= 2;
        LOGGER.debug("Retrieving hotspots from SonarQube version: {} (major version {} minor version {})", string3, n, n2);
        if (bl2 || bl) {
            List<Hotspots.SearchWsResponse.Hotspot> list = this.getSecurityHotspotsForSonarQubeHigherThan7(string, string2);
            for (Hotspots.SearchWsResponse.Hotspot hotspot : list) {
                try {
                    String string4 = hotspot.getKey();
                    ShowRequest showRequest = new ShowRequest();
                    showRequest.setHotspot(string4);
                    Hotspots.ShowWsResponse showWsResponse = this.wsClient.hotspots().show(showRequest);
                    String string5 = showWsResponse.getRule().getKey();
                    Long l = hashMap.getOrDefault(string5, 0L) + 1L;
                    hashMap.put(string5, l);
                }
                catch (Exception exception) {
                    LOGGER.warn("Error getting info from hotspot ({}), reason: {}", (Object)hotspot.getKey(), (Object)exception.getMessage());
                }
            }
        } else if (n >= 7) {
            org.sonarqube.ws.client.issues.SearchRequest searchRequest = new org.sonarqube.ws.client.issues.SearchRequest();
            searchRequest.setComponentKeys(Collections.singletonList(string));
            searchRequest.setTypes(Collections.singletonList("SECURITY_HOTSPOT"));
            searchRequest.setFacets(Collections.singletonList(RULES));
            searchRequest.setResolved("false");
            if (string2 != null && !string2.isEmpty()) {
                searchRequest.setBranch(string2);
            }
            hashMap.putAll(this.getSecurityHotspotsForSonarQube7(searchRequest));
            LOGGER.debug("Total hotspots rules with issues found:  {}", (Object)hashMap.size());
        } else {
            LOGGER.warn("SonarQube {} version doesn't support Security HotSpots. No HotSpots found.", (Object)string3);
        }
        return this.sortByValue(hashMap);
    }

    protected Map<String, Long> getSecurityHotspotsForSonarQube7(org.sonarqube.ws.client.issues.SearchRequest searchRequest) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Issues.SearchWsResponse searchWsResponse = this.wsClient.issues().search(searchRequest);
        for (Common.Facet facet : searchWsResponse.getFacets().getFacetsList()) {
            if (!RULES.equals(facet.getProperty())) continue;
            List<Common.FacetValue> list = facet.getValuesList();
            for (Common.FacetValue facetValue : list) {
                String string = facetValue.getVal();
                Long l = facetValue.getCount();
                hashMap.put(string, l);
            }
        }
        return hashMap;
    }

    public Map<String, Long> getAllSecurityHotspots(String string) {
        return this.getSecurityHotspotsForSeverity(string, null, null);
    }

    public Map<String, Long> getAllSecurityHotspots(String string, String string2) {
        return this.getSecurityHotspotsForSeverity(string, null, string2);
    }

    public Map<String, Long> getSecurityHotspotsForSeverity(String string, String string2) {
        return this.getSecurityHotspotsForSeverity(string, string2, null);
    }

    public Map<String, Long> getSecurityHotspotsForSeverity(String string, String string2, String string3) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        String string4 = "7.9";
        try {
            string4 = SonarQubeServerManager.getSonarQubeVersion(this.wsClient);
        }
        catch (SonarQubeException sonarQubeException) {
            LOGGER.error("Unable to get SonarQube version from server: {}", (Object)sonarQubeException.getMessage(), (Object)sonarQubeException);
            LOGGER.warn("We will use {} LTS to retrieve hotsposts", (Object)string4);
        }
        int n = Integer.parseInt(string4.substring(0, 1));
        int n2 = Integer.parseInt(string4.substring(2, 3));
        boolean bl = SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl());
        boolean bl2 = n > 8 || n == 8 && n2 >= 2;
        LOGGER.debug("Retrieving hotspots for {} for severity {} and version {} (major version {} minor version {})", string, string2, string4, n, n2);
        if (bl2 || bl) {
            List<Hotspots.SearchWsResponse.Hotspot> list = this.getSecurityHotspotsForSonarQubeHigherThan7(string, string3);
            for (Hotspots.SearchWsResponse.Hotspot hotspot : list) {
                try {
                    String string5 = hotspot.getKey();
                    ShowRequest showRequest = new ShowRequest();
                    showRequest.setHotspot(string5);
                    Hotspots.ShowWsResponse showWsResponse = this.wsClient.hotspots().show(showRequest);
                    String string6 = showWsResponse.getRule().getKey();
                    String string7 = SonarQubeRuleManager.getRule(this.wsClient, string6).getSeverity();
                    if (string2 != null && !string2.equals(string7)) continue;
                    Long l = hashMap.getOrDefault(string6, 0L) + 1L;
                    hashMap.put(string6, l);
                }
                catch (Exception exception) {
                    LOGGER.warn("Error getting info from hotspot ({}), reason: {}", (Object)hotspot.getKey(), (Object)exception.getMessage());
                }
            }
        } else if (n >= 7) {
            org.sonarqube.ws.client.issues.SearchRequest searchRequest = new org.sonarqube.ws.client.issues.SearchRequest();
            searchRequest.setComponentKeys(Collections.singletonList(string));
            searchRequest.setTypes(Collections.singletonList("SECURITY_HOTSPOT"));
            if (string2 != null) {
                searchRequest.setSeverities(Collections.singletonList(string2));
            }
            searchRequest.setFacets(Collections.singletonList(RULES));
            searchRequest.setResolved("false");
            if (string3 != null && !string3.isEmpty()) {
                searchRequest.setBranch(string3);
            }
            hashMap.putAll(this.getSecurityHotspotsForSonarQube7(searchRequest));
            LOGGER.debug("Total hotspots rules with issues found for severity {}:  {}", (Object)string2, (Object)hashMap.size());
        } else {
            LOGGER.warn("SonarQube {} version doesn't support Security HotSpots. No HotSpots found.", (Object)string4);
        }
        return this.sortByValue(hashMap);
    }

    public List<Hotspots.ShowWsResponse> getSecurityHotspotsForRule(String string, String string2) {
        return this.getSecurityHotspotsForRule(string, string2, null);
    }

    public List<Hotspots.ShowWsResponse> getSecurityHotspotsForRule(SonarQubeProject sonarQubeProject2, String string, String string2) {
        ArrayList<Hotspots.ShowWsResponse> arrayList = new ArrayList<Hotspots.ShowWsResponse>();
        switch (sonarQubeProject2.getSonarQubeQualifier()) {
            case PROJECT: {
                return this.getSecurityHotspotsForRule(sonarQubeProject2.getKey(), string, string2);
            }
            case APPLICATION: {
                ((SonarQubeApplication)sonarQubeProject2).getProjects().forEach(sonarQubeProject -> arrayList.addAll(this.getSecurityHotspotsForRule(sonarQubeProject.getKey(), string, sonarQubeProject.getBranchName())));
                break;
            }
            case PORTFOLIO: {
                ((SonarQubePortfolio)sonarQubeProject2).getSonarQubeProjectList().forEach(sonarQubeProject -> arrayList.addAll(this.getSecurityHotspotsForRule(sonarQubeProject.getKey(), string, string2)));
                break;
            }
        }
        return arrayList;
    }

    public List<Hotspots.ShowWsResponse> getSecurityHotspotsForRule(String string, String string2, String string3) {
        ArrayList<Hotspots.ShowWsResponse> arrayList = new ArrayList<Hotspots.ShowWsResponse>();
        List<Hotspots.SearchWsResponse.Hotspot> list = this.getSecurityHotspotsForSonarQubeHigherThan7(string, string3);
        for (Hotspots.SearchWsResponse.Hotspot hotspot : list) {
            String string4 = hotspot.getKey();
            ShowRequest showRequest = new ShowRequest();
            showRequest.setHotspot(string4);
            Hotspots.ShowWsResponse showWsResponse = this.wsClient.hotspots().show(showRequest);
            String string5 = showWsResponse.getRule().getKey();
            if (!string2.equals(string5)) continue;
            arrayList.add(showWsResponse);
        }
        return arrayList;
    }

    protected List<Hotspots.SearchWsResponse.Hotspot> getSecurityHotspotsForSonarQubeHigherThan7(String string, String string2) {
        return this.getHotspotsForSonarQubeHigherThan7(string, string2, false);
    }

    protected List<Hotspots.SearchWsResponse.Hotspot> getAllSecurityHotspotsForSonarQubeHigherThan7(String string, String string2) {
        return this.getHotspotsForSonarQubeHigherThan7(string, string2, true);
    }

    private List<Hotspots.SearchWsResponse.Hotspot> getHotspotsForSonarQubeHigherThan7(String string, String string2, boolean bl) {
        SearchRequest searchRequest = SonarQubeHotspotManager.createSearchHotspotRequest(string, string2, 1, bl);
        Hotspots.SearchWsResponse searchWsResponse = this.wsClient.hotspots().search(searchRequest);
        ArrayList<Hotspots.SearchWsResponse.Hotspot> arrayList = new ArrayList<Hotspots.SearchWsResponse.Hotspot>(searchWsResponse.getHotspotsList());
        if (searchWsResponse.hasPaging()) {
            Integer n = searchWsResponse.getPaging().getTotal();
            if (n > 10000) {
                LOGGER.warn("Found {} hotspots and SonarQube limit is 10000 hotspots. We will only return the first 10000 hotspots!", (Object)n);
            }
            LOGGER.debug("Total hotspots found: {}", (Object)n);
            double d2 = Math.ceil((double)n.intValue() / 500.0);
            LOGGER.debug("Total hotspot pages:  {}", (Object)d2);
            d2 = Math.min(d2, 20.0);
            int n2 = 2;
            while ((double)n2 <= d2) {
                LOGGER.debug("Requesting hotspots page {} of {}", (Object)n2, (Object)d2);
                searchRequest = SonarQubeHotspotManager.createSearchHotspotRequest(string, string2, n2, bl);
                searchWsResponse = this.wsClient.hotspots().search(searchRequest);
                arrayList.addAll(searchWsResponse.getHotspotsList());
                ++n2;
            }
        }
        return arrayList;
    }

    public SonarQubeHotspotsBreakdown getSonarQubeHotspotsBreakdown(String string, String string2) {
        return this.getHotspotsBreakdown(Collections.singletonList(string), string2, false);
    }

    public SonarQubeHotspotsBreakdown getAllSonarQubeHotspotsBreakdown(String string, String string2) {
        return this.getHotspotsBreakdown(Collections.singletonList(string), string2, true);
    }

    public SonarQubeHotspotsBreakdown getSonarQubeHotspotsBreakdown(List<String> list) {
        return this.getHotspotsBreakdown(list, null, false);
    }

    public SonarQubeHotspotsBreakdown getAllSonarQubeHotspotsBreakdown(List<String> list) {
        return this.getHotspotsBreakdown(list, null, true);
    }

    public SonarQubeHotspotsBreakdown getSonarQubeHotspotsBreakdown(List<String> list, String string) {
        return this.getHotspotsBreakdown(list, string, false);
    }

    public SonarQubeHotspotsBreakdown getAllSonarQubeHotspotsBreakdown(List<String> list, String string) {
        return this.getHotspotsBreakdown(list, string, true);
    }

    private SonarQubeHotspotsBreakdown getHotspotsBreakdown(List<String> list, String string, boolean bl) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        HashMap<String, Long> hashMap2 = new HashMap<String, Long>();
        SonarQubeHotspotsBreakdown sonarQubeHotspotsBreakdown = new SonarQubeHotspotsBreakdown();
        List<SonarQubeHotspotsPerCategory> list2 = this.getHotspotsPerCategoryList(list, string, bl);
        sonarQubeHotspotsBreakdown.setSonarQubeHotspotsPerCategoriesByPriority(list2);
        list2.forEach(sonarQubeHotspotsPerCategory -> {
            Long l = hashMap.getOrDefault(sonarQubeHotspotsPerCategory.getCategoryKey(), 0L) + 1L;
            Long l2 = hashMap2.getOrDefault(sonarQubeHotspotsPerCategory.getPriority(), 0L) + 1L;
            hashMap.put(sonarQubeHotspotsPerCategory.getCategoryKey(), l);
            hashMap2.put(sonarQubeHotspotsPerCategory.getPriority(), l2);
        });
        sonarQubeHotspotsBreakdown.setCategories(hashMap);
        sonarQubeHotspotsBreakdown.setPriorities(hashMap2);
        List<SonarQubeHotspotsPerCategory> list3 = list2.stream().filter(sonarQubeHotspotsPerCategory -> sonarQubeHotspotsPerCategory.getPriority().equals("LOW")).collect(Collectors.toList());
        List<SonarQubeHotspotsPerCategory> list4 = list2.stream().filter(sonarQubeHotspotsPerCategory -> sonarQubeHotspotsPerCategory.getPriority().equals("MEDIUM")).collect(Collectors.toList());
        List<SonarQubeHotspotsPerCategory> list5 = list2.stream().filter(sonarQubeHotspotsPerCategory -> sonarQubeHotspotsPerCategory.getPriority().equals("HIGH")).collect(Collectors.toList());
        sonarQubeHotspotsBreakdown.setLowHotspotsPerCategoryList(list3);
        sonarQubeHotspotsBreakdown.setMediumHotspotsPerCategoryList(list4);
        sonarQubeHotspotsBreakdown.setHighHotspotsPerCategoryList(list5);
        Map<String, List<SonarQubeHotspotsPerCategory>> map = SonarQubeHotspotManager.getSecurityHotspotPerCategoryByPriority(hashMap, list3);
        Map<String, List<SonarQubeHotspotsPerCategory>> map2 = SonarQubeHotspotManager.getSecurityHotspotPerCategoryByPriority(hashMap, list4);
        Map<String, List<SonarQubeHotspotsPerCategory>> map3 = SonarQubeHotspotManager.getSecurityHotspotPerCategoryByPriority(hashMap, list5);
        LinkedHashMap<String, List<SonarQubeHotspotsPerCategory>> linkedHashMap = new LinkedHashMap<String, List<SonarQubeHotspotsPerCategory>>();
        linkedHashMap.putAll(SonarQubeHotspotManager.sortBySonarQubeHotspotPerCategoriesCount(map3));
        linkedHashMap.putAll(SonarQubeHotspotManager.sortBySonarQubeHotspotPerCategoriesCount(map2));
        linkedHashMap.putAll(SonarQubeHotspotManager.sortBySonarQubeHotspotPerCategoriesCount(map));
        sonarQubeHotspotsBreakdown.setSonarQubeHotspotsPerCategoriesByPriorityMap(linkedHashMap);
        sonarQubeHotspotsBreakdown.setLowSecurityHotspotPerCategory(map);
        sonarQubeHotspotsBreakdown.setMediumSecurityHotspotPerCategory(map2);
        sonarQubeHotspotsBreakdown.setHighSecurityHotspotPerCategory(map3);
        return sonarQubeHotspotsBreakdown;
    }

    private static Map<String, List<SonarQubeHotspotsPerCategory>> getSecurityHotspotPerCategoryByPriority(Map<String, Long> map, List<SonarQubeHotspotsPerCategory> list) {
        HashMap<String, List<SonarQubeHotspotsPerCategory>> hashMap = new HashMap<String, List<SonarQubeHotspotsPerCategory>>();
        list.forEach(sonarQubeHotspotsPerCategory -> map.keySet().forEach(string -> {
            if (string.equals(sonarQubeHotspotsPerCategory.getCategoryKey())) {
                List list = hashMap.getOrDefault(string, new ArrayList());
                list.add(sonarQubeHotspotsPerCategory);
                hashMap.put((String)string, list);
            }
        }));
        return SonarQubeHotspotManager.sortBySonarQubeHotspotPerCategoriesCount(hashMap);
    }

    public List<SonarQubeHotspotsPerCategory> getSonarQubeHotspotsPerCategoryList(List<String> list, String string) {
        return this.getHotspotsPerCategoryList(list, string, false);
    }

    public List<SonarQubeHotspotsPerCategory> getAllSonarQubeHotspotsPerCategoryList(List<String> list, String string) {
        return this.getHotspotsPerCategoryList(list, string, true);
    }

    private List<SonarQubeHotspotsPerCategory> getHotspotsPerCategoryList(List<String> list, String string, boolean bl) {
        List<SonarQubeHotspotsPerCategory> list2 = new ArrayList<SonarQubeHotspotsPerCategory>();
        try {
            String string2 = SonarQubeServerManager.getSonarQubeVersion(this.wsClient);
            if (SonarQubeHotspotManager.useHotspotApiEndpoint(this.wsClient.wsConnector().baseUrl(), string2)) {
                list2 = this.getSonarQubeHotspotsPerCategoryListWithHotspotsEndpoint(list, string, bl);
            } else {
                LOGGER.warn("SonarQube version ({}), is not compatible with SonarQubeHotspotsBreakdown, you need to use SonarQubeIssuesBreakdown.", (Object)string2);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error getting SonarQube/SonarCloud version to retrieve hotspots, reason -> {}", (Object)exception.getMessage());
            LOGGER.debug("Error getting SonarQube/SonarCloud version to retrieve hotspots", exception);
        }
        return SonarQubeHotspotManager.sortSonarQubeHotspotsPerCategoryListByPriority(list2);
    }

    private List<SonarQubeHotspotsPerCategory> getSonarQubeHotspotsPerCategoryListWithHotspotsEndpoint(List<String> list, String string, boolean bl) {
        ArrayList<SonarQubeHotspotsPerCategory> arrayList = new ArrayList<SonarQubeHotspotsPerCategory>();
        boolean bl2 = list.size() == 1;
        list.forEach(string2 -> {
            try {
                SearchRequest searchRequest = SonarQubeHotspotManager.createSearchHotspotRequest(string2, string, 1, bl);
                Hotspots.SearchWsResponse searchWsResponse = this.wsClient.hotspots().search(searchRequest);
                searchWsResponse.getHotspotsList().forEach(hotspot -> {
                    SonarQubeHotspotsPerCategory sonarQubeHotspotsPerCategory = SonarQubeHotspotManager.createSonarQubeHotspotsPerCategory(hotspot, this.wsClient.wsConnector().baseUrl(), string, bl2);
                    arrayList.add(sonarQubeHotspotsPerCategory);
                });
                Integer n = searchWsResponse.getPaging().getTotal();
                LOGGER.debug("Total hotspots found: {}", (Object)n);
                if (searchWsResponse.hasPaging()) {
                    if (n > 10000) {
                        LOGGER.warn("Found {} hotspots and SonarQube limit is 10000 hotspots. We will only return the first 10000 hotspots!", (Object)n);
                    }
                    double d2 = Math.ceil((double)n.intValue() / 500.0);
                    LOGGER.debug("Total hotspot pages:  {}", (Object)d2);
                    d2 = Math.min(d2, 20.0);
                    int n2 = 2;
                    while ((double)n2 <= d2) {
                        LOGGER.debug("Requesting hotspots page {} of {}", (Object)n2, (Object)d2);
                        searchRequest = SonarQubeHotspotManager.createSearchHotspotRequest(string2, string, n2, bl);
                        searchWsResponse = this.wsClient.hotspots().search(searchRequest);
                        searchWsResponse.getHotspotsList().forEach(hotspot -> {
                            SonarQubeHotspotsPerCategory sonarQubeHotspotsPerCategory = SonarQubeHotspotManager.createSonarQubeHotspotsPerCategory(hotspot, this.wsClient.wsConnector().baseUrl(), string, bl2);
                            arrayList.add(sonarQubeHotspotsPerCategory);
                        });
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to get hotspots for {} and branch {}", string2, (Object)string);
                LOGGER.debug("Error getting SonarQube/SonarCloud hotspot for {}", string2, (Object)exception);
            }
        });
        return arrayList;
    }

    private static SearchRequest createSearchHotspotRequest(String string, String string2, int n, boolean bl) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setProjectKey(string);
        searchRequest.setPs(PS_PARAMETER);
        searchRequest.setP(Integer.toString(n));
        if (!bl) {
            searchRequest.setStatus(TO_REVIEW);
        }
        if (string2 != null && !string2.isEmpty()) {
            searchRequest.setBranch(string2);
        }
        return searchRequest;
    }

    private static SonarQubeHotspotsPerCategory createSonarQubeHotspotsPerCategory(Hotspots.SearchWsResponse.Hotspot hotspot, String string, String string2, boolean bl) {
        String string3 = ":BRANCH:" + string2;
        SonarQubeHotspotsPerCategory sonarQubeHotspotsPerCategory = new SonarQubeHotspotsPerCategory();
        String string4 = hotspot.getProject().replace(string3, "");
        String string5 = hotspot.getComponent().replace(string4 + ":", "").replace(string3, "");
        sonarQubeHotspotsPerCategory.setProject(string4);
        sonarQubeHotspotsPerCategory.setComponent(string5);
        sonarQubeHotspotsPerCategory.setKey(hotspot.getKey());
        sonarQubeHotspotsPerCategory.setStatus(hotspot.getStatus());
        sonarQubeHotspotsPerCategory.setMessage(hotspot.getMessage());
        sonarQubeHotspotsPerCategory.setCodeLine(hotspot.getLine());
        sonarQubeHotspotsPerCategory.setCategoryKey(hotspot.getSecurityCategory());
        sonarQubeHotspotsPerCategory.setCategory(SonarQubeHotspotCategory.getHotspotCategory(hotspot.getSecurityCategory()));
        sonarQubeHotspotsPerCategory.setPriority(hotspot.getVulnerabilityProbability());
        sonarQubeHotspotsPerCategory.setType(Common.RuleType.SECURITY_HOTSPOT.toString());
        sonarQubeHotspotsPerCategory.setResolution(hotspot.getResolution());
        if (bl) {
            sonarQubeHotspotsPerCategory.setLineUrl(SonarQubeHotspotManager.getSecurityHotspotLineUrl(string, sonarQubeHotspotsPerCategory, string2));
        } else {
            sonarQubeHotspotsPerCategory.setLineUrl(SonarQubeHotspotManager.getSecurityHotspotLineUrl(string, sonarQubeHotspotsPerCategory, null));
        }
        return sonarQubeHotspotsPerCategory;
    }

    private static List<SonarQubeHotspotsPerCategory> sortSonarQubeHotspotsPerCategoryListByPriority(List<SonarQubeHotspotsPerCategory> list) {
        List<String> list2 = Arrays.asList("HIGH", "MEDIUM", "LOW");
        return list.stream().sorted(Comparator.comparing(sonarQubeHotspotsPerCategory -> list2.indexOf(sonarQubeHotspotsPerCategory.getPriority())).thenComparing(SonarQubeHotspotsPerCategory::getPriority)).collect(Collectors.toList());
    }

    protected static boolean useHotspotApiEndpoint(String string, String string2) {
        if (string2.length() < 3) {
            throw new IllegalArgumentException("Wrong sonarqube version length (" + string2 + ")");
        }
        int n = Integer.parseInt(string2.substring(0, 1));
        int n2 = Integer.parseInt(string2.substring(2, 3));
        boolean bl = string.startsWith(SONARCLOUD_URL);
        boolean bl2 = n > 8 || n == 8 && n2 >= 2;
        return bl || bl2;
    }

    private static String getSecurityHotspotLineUrl(String string, SonarQubeHotspotsPerCategory sonarQubeHotspotsPerCategory, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (stringBuilder.toString().endsWith("/")) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        if (string.startsWith(SONARCLOUD_URL)) {
            stringBuilder.append("/project");
        }
        stringBuilder.append("/security_hotspots?id=").append(sonarQubeHotspotsPerCategory.getProject()).append("&hotspots=").append(sonarQubeHotspotsPerCategory.getKey());
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append("&branch=").append(string2);
        }
        return stringBuilder.toString();
    }

    private Map<String, Long> sortByValue(Map<String, Long> map) {
        return map.entrySet().stream().sorted((entry, entry2) -> ((Long)entry2.getValue()).compareTo((Long)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (l, l2) -> l, LinkedHashMap::new));
    }

    private static Map<String, List<SonarQubeHotspotsPerCategory>> sortBySonarQubeHotspotPerCategoriesCount(Map<String, List<SonarQubeHotspotsPerCategory>> map) {
        Comparator<Map.Entry> comparator = Comparator.comparingInt(entry -> ((List)entry.getValue()).size());
        List<SonarQubeHotspotsPerCategory> list3 = map.get(OTHERS_CATEGORY_KEY);
        map.remove(OTHERS_CATEGORY_KEY);
        Map map2 = map.entrySet().stream().sorted(comparator.reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (list, list2) -> list2, LinkedHashMap::new));
        if (list3 != null) {
            map2.put(OTHERS_CATEGORY_KEY, list3);
        }
        return map2;
    }
}

