/*
 * Decompiled with CFR 0.152.
 */
package es.sonarqube.managers;

import es.sonarqube.api.SearchRulesResponse;
import es.sonarqube.api.SonarQubeCustomRequestParam;
import es.sonarqube.cache.Cache;
import es.sonarqube.cache.CacheManager;
import es.sonarqube.exceptions.ExceptionUtils;
import es.sonarqube.exceptions.SonarQubeException;
import es.sonarqube.managers.SonarQubeCustomRequestManager;
import es.sonarqube.managers.SonarQubeURLManager;
import es.sonarqube.utils.ParamsUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarqube.ws.Rules;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.rules.SearchRequest;

public class SonarQubeRuleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonarQubeRuleManager.class);
    private final WsClient wsClient;
    public static final String PAGE_SIZE_PARAM = "500";

    public SonarQubeRuleManager(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public SonarQubeRuleManager(String string, String string2) {
        this.wsClient = WsClientFactories.getDefault().newClient(HttpConnector.newBuilder().url(string).token(string2).build());
    }

    protected static Rules.Rule getRule(WsClient wsClient, String string) throws SonarQubeException {
        return new SonarQubeRuleManager(wsClient).getRule(string);
    }

    public Rules.Rule getRule(String string) throws SonarQubeException {
        try {
            Cache cache = CacheManager.getCacheInstance();
            Rules.Rule rule = (Rules.Rule)cache.get(string);
            if (rule == null) {
                LOGGER.debug("Contacting SonarQube to get rule: {}", (Object)string);
                rule = SonarQubeURLManager.isSonarCloud(this.wsClient.wsConnector().baseUrl()) ? this.getSonarCloudRule(string) : this.getSonarQubeRule(string);
                cache.add(string, rule);
            } else {
                LOGGER.debug("Rule obtained from cache: {}", (Object)string);
            }
            return rule;
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format("Error getting rule (%s) ", string));
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.debug(String.format("Error getting rule (%s) ", string));
            throw new SonarQubeException(String.format("Error getting rule, error -> %s", exception.getMessage()));
        }
    }

    private Rules.Rule getSonarQubeRule(String string) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setRuleKey(string);
        Rules.SearchResponse searchResponse = this.wsClient.rules().search(searchRequest);
        Rules.Rule rule = searchResponse != null && searchResponse.getRulesList().size() == 1 ? searchResponse.getRulesList().get(0) : Rules.Rule.newBuilder().setName(string).setLang("-").setLangName("-").build();
        return rule;
    }

    private Rules.Rule getSonarCloudRule(String string) {
        ArrayList<SonarQubeCustomRequestParam> arrayList = new ArrayList<SonarQubeCustomRequestParam>();
        SonarQubeCustomRequestParam sonarQubeCustomRequestParam = new SonarQubeCustomRequestParam();
        sonarQubeCustomRequestParam.setParamKey("rule_key");
        sonarQubeCustomRequestParam.setParamValue(string);
        SonarQubeCustomRequestParam sonarQubeCustomRequestParam2 = ParamsUtils.getOrganizationParam("sonarsource");
        arrayList.add(sonarQubeCustomRequestParam);
        arrayList.add(sonarQubeCustomRequestParam2);
        SearchRulesResponse searchRulesResponse = SonarQubeCustomRequestManager.callCustomGetMethodWithSpecificResponseType(this.wsClient, "rules", "search", arrayList, SearchRulesResponse.class);
        Rules.Rule rule = searchRulesResponse != null && searchRulesResponse.getRules().size() == 1 ? ParamsUtils.sonarQubeRuleToRule(searchRulesResponse.getRules().get(0)) : Rules.Rule.newBuilder().setName(string).setLang("-").setLangName("-").build();
        return rule;
    }

    protected static List<Rules.Rule> getRulesByQualityProfile(WsClient wsClient, String string, String string2) throws SonarQubeException {
        return new SonarQubeRuleManager(wsClient).getRulesByQualityProfile(string, string2);
    }

    public List<Rules.Rule> getRulesByQualityProfile(String string, String string2) throws SonarQubeException {
        try {
            ArrayList<Rules.Rule> arrayList = new ArrayList<Rules.Rule>();
            if (ParamsUtils.hasValue(string)) {
                LOGGER.debug("Contacting SonarQube to get rule list for Quality profile : {}", (Object)string);
                SearchRequest searchRequest = this.createRuleSearchRequest(string, string2, "1");
                Rules.SearchResponse searchResponse = this.wsClient.rules().search(searchRequest);
                if (searchResponse != null) {
                    arrayList.addAll(searchResponse.getRulesList());
                    if (searchResponse.getTotal() > searchResponse.getPs()) {
                        int n = (int)Math.floor((double)searchResponse.getTotal() / (double)searchResponse.getPs()) + 1;
                        for (int i = 2; i <= n; ++i) {
                            searchRequest = this.createRuleSearchRequest(string, string2, String.valueOf(i));
                            searchResponse = this.wsClient.rules().search(searchRequest);
                            arrayList.addAll(searchResponse.getRulesList());
                        }
                    }
                }
            }
            return arrayList;
        }
        catch (HttpException httpException) {
            LOGGER.debug(String.format("Error getting rule list from quality profile  (%s) ", string));
            throw ExceptionUtils.getSonarQubeException(httpException);
        }
        catch (Exception exception) {
            LOGGER.debug(String.format("Error getting rule list from quality profile  (%s) ", string));
            throw new SonarQubeException(String.format("Error getting rule, error -> %s", exception.getMessage()));
        }
    }

    private SearchRequest createRuleSearchRequest(String string, String string2, String string3) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setQprofile(string);
        searchRequest.setActivation(string2);
        searchRequest.setPs(PAGE_SIZE_PARAM);
        searchRequest.setP(string3);
        return searchRequest;
    }
}

